
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_ComponentClass : BaseTest 
	{

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
		}

		[Test]
		public void GetComponentClassFromId_Pass()
		{
			DataTable dtTest = DAL.ComponentClass.GetComponentClassFromId(1);

			Assert.AreEqual(true, dtTest.Rows.Count > 0, "Rows.Count");
			Assert.AreEqual(7, dtTest.Columns.Count, "Columns.Count");
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassId), TABLES.ComponentClass.ComponentClassId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassShortName), TABLES.ComponentClass.ComponentClassShortName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.ComponentClassName), TABLES.ComponentClass.ComponentClassName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.CprsOrderableItemId), TABLES.ComponentClass.CprsOrderableItemId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.SortColumn), TABLES.ComponentClass.SortColumn);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.LastUpdateUser), TABLES.ComponentClass.LastUpdateUser);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ComponentClass.RowVersion), TABLES.ComponentClass.RowVersion);
		}

		[Test]
		public void GetComponentClassFromId_Fail()
		{		
			DataTable dtTest = DAL.ComponentClass.GetComponentClassFromId(0);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}
  
	}
}
#endif
